/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.container.property;

import javax.annotation.Nullable;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_client.container.property.PropertyType;
import net.minecraft.network.FriendlyByteBuf;

public class FrequencyPropertyData<FREQUENCY extends Frequency>
extends PropertyData {
    @Nullable
    private final FREQUENCY value;

    public FrequencyPropertyData(short property, @Nullable FREQUENCY value) {
        super(PropertyType.FREQUENCY, property);
        this.value = value;
    }

    public static <FREQUENCY extends Frequency> FrequencyPropertyData<FREQUENCY> readFrequency(short property, FriendlyByteBuf buffer) {
        return new FrequencyPropertyData<Frequency>(property, BasePacketHandler.readOptional(buffer, Frequency::readFromPacket));
    }

    @Override
    public void handleWindowProperty(MekanismContainer container) {
        container.handleWindowProperty(this.getProperty(), this.value);
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        BasePacketHandler.writeOptional(buffer, this.value, (buf, val) -> val.write((FriendlyByteBuf)buf));
    }
}

